
/*
 * Header file for data structures that describes airfoil section.
 */

#define MAXPOINTS 150		/* max number of points allowed in data */
#define TXTSIZ 150		/* size of text strings */

typedef struct {
   double x, y;
} point_t;

/*
 * The structure that describes airfoil section data.
 * All ordinates are in [0,1].
 */
typedef struct {
   char title[TXTSIZ];		/* The name of the section */
   int npoints;			/* Number of points */
   point_t points[MAXPOINTS];	/* all the data points */
   double miny, maxy;		/* vertical extents */
   double thickness, th_loc;	/* max thickness and its location */
   double camber, cam_loc;	/* max camber and its location */
} airfoil_data_t;

extern int read_foil(FILE *fp, char *f, airfoil_data_t *info);
extern void writefoil(FILE *fout, airfoil_data_t *foil, int, int);
extern void get_otherside(point_t *new, point_t *old, int n);
extern void fill_in(point_t *others, int n1, point_t *pts, int n2);
