
#include "config.h"

#define in(c, s) strchr(s, c)

/*
 * useful macros
 */
#define streq(a, b)   (strcmp((a),(b)) == 0)
#ifndef min
#define min(a,b) (((a) < (b))?(a):(b))
#endif
#ifndef max
#define max(a,b) (((a) > (b))?(a):(b))
#endif

/* Stupid Turbo-C has a broken abs */
#ifdef MSDOS
#ifdef abs
#undef abs
#endif
#endif

#ifndef abs
#define abs(a) (((a) < 0)? -(a) : (a))
#endif

/*
 * To compare two slopes without division: is ay/ax > by/bx?  Multiply both
 * sides by ax.bx. Now if ax.bx is positive we compare ay.bx > by.ax;
 * otherwise switch the sense. This is xor.
 */
#define m_gt(a, b) ( ((a).x*(b).x < 0) ^ ((a).y*(b).x > (b).y*(a).x) )

#ifdef MSDOS
#define OPTIONCHARS "-/"
#else
#define OPTIONCHARS "-"
#endif
#define optionchar(c) in(c, OPTIONCHARS)

#define EPSILON 1.0e-6
