
/*
 * naca.c
 *
 * Generate points for the NACA 4 and 5 digit airfoils.
 *
 *                        NACA 4-digit Airfoils
 *
 * The first digit gives the camber (in % chord); the second the x-value
 * of the max. camber point (in tenths chord); the last two are the thickness
 * (in % chord.). Thus a NACA 4312 has a 4% camber, with max. camber at 30%
 * chord, and has a thickness of 12%.
 *
 * The camber line consists of two parabolae that are joined smoothly with
 * horizontal slope at the max. camber point (x_a, y_a). Thus the equations
 * for the camber line become:
 *
 *    y = y_a/x_a^2 x (2x_a - x)                   0 <= x <= x_a
 *    y = y_a / (1 - x_a)^2 (1 - x)(1 + x - 2x_a)  x_a <= x <= 1
 *
 * This camber line deforms the standard NACA streamline shape:
 *    +-d = t [ 1.4845 sqrt(x) - 0.63 x - 1.758 x^2 + 1.4215 x^3 - 0.5075 x^4 ]
 *
 * So for each point x, find the point on the camber line c(x) and the normal
 * to it. Then along the normal find points at a distance of +- d, the
 * thickness function.
 *
 *
 *			    NACA 5-digit Airfoils
 *
 * The 4-digit airfoils have the property that at the max. camber point the
 * radius of curvature changes discontinuously. This implies a discontinuous
 * centripetal acceleration in the airstream; to ameliorate this, the camber
 * line is modified to one of two forms:
 *
 * i)  the "simple" camber line: this consists of a cubic joined to a straight
 *     line. At the joining point, both the slope and curvature are continuous.
 * ii) the "reflexed" camber line: this consists of two cubics joined together
 *
 * The third digit is either 0 (simple camber) or 1 (reflexed camber). The
 * last two digits are thickness just as in the 4-digit case. The first two
 * digits define the camber line. The second digit is multiplied by 5 to give
 * the position of max camber. The max. camber is defined according to this
 * table:
 *  second digit -> 	1	2	3	4	5
 *  first digit
 *		2	1.1	1.5	1.8	2.1	2.3
 *		3		2.3	2.8	3.1
 *		4		3.1	3.7	4.2
 *		6		4.6	5.5	6.2
 *
 * Unfortunately I don't know how to generate the camber line from this
 * information; for each cubic now we have two points and one slope, which is
 * not enough to uniqely determine the curves.
 *
 */

