/*
 * Copyright 1992 Shamim P. Mohamed
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author:
 * shamim@math.isu.edu
 * Shamim Mohamed
 * Dept. of Mathematics
 * Idaho State University
 *
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#ifdef STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <ctype.h>
#include <math.h>

#include "foil_lib.h"
#include "lib.h"

#define MAX_SPARS  10		/* max number of spars for airfoil */

/*
 * Page parameters, for plots that take up more than one sheet. Remember,
 * the page is considered to be in landscape orientation, so the width is
 * greater than the height. This is for US letter (8.5" x 11"); European
 * users using A4 may wish to change these numbers.
 *
 * The margin is space to leave on all sides; the ljet4 driver for
 * ghostscript, for instance, puts the page too far to the left and down.
 * Depending on your printer this may need adjustment.
 */
#define MARGIN 20
#define PAGEWIDTH (750-2*MARGIN)
#define PAGEHEIGHT (600-2*MARGIN)

/* This is the actual size of the page in points: */
#define PS_WIDTH  612
#define PS_HEIGHT 792
/*
 * output scaling etc. 
 */
#define SCALE  	10000		/* size of the field (output)        */
#define RADIUS     10       	/* radius of circles denoting points */

#define PS 12
#define VS 13.4
#define TITLE_SIZE 30
#define CROSS_SIZE 20

/*
 * type definitions
 */

typedef struct {
   float raw_value, scale, pts;
   char *units;
} value_t;

typedef struct {
   float offset;
   value_t thick;
} spar_t;

#include "COPYRIGHT"
