


plotfoil(1l)                                         plotfoil(1l)


NNAAMMEE
       pplloottffooiill - generate a PostScript plot of airfoil data.
       eeddiittffooiill - modify camber and thickness of airfoil data.
       mmiixxffooiillss - interpolate between two airfoil sections.

SSYYNNTTAAXX
       pplloottffooiill [_o_p_t_i_o_n_s] [_f_i_l_e_n_a_m_e_._._.]
       eeddiittffooiill [_o_p_t_i_o_n_s] [_f_i_l_e_n_a_m_e]
       mmiixxffooiillss [_o_p_t_i_o_n_s] _s_e_c_t_i_o_n_1 _s_e_c_t_i_o_n_2

DDEESSCCRRIIPPTTIIOONN
       pplloottffooiill  plots  (in  PostScript)  airfoil sections (well,
       actually any section that is not smoothly closed). It  can
       also  allow  for  spars, sheeting, and prints registration
       marks that are aligned with the L.E.  and  T.E.   It  uses
       Bezier splines to interpolate between data points, with an
       option to use straight lines instead.

       The other two programs, eeddiittffooiill and mmiixxffooiillss, modify air-
       foil  data. By default they send the data to standard out-
       put, so they can be used in a pipe to pplloottffooiill to plot the
       results. (Unix only.)

OOVVEERRVVIIEEWW
       Plotfoil  reads airfoil data and generates PostScript code
       that when printed on a PostScript printer will  deliver  a
       plot of the airfoil section along with spars (if any). The
       bounds of the section are also drawn,  with  crosses,  and
       these  can  be  used  for registration of the ribs or tem-
       plates. If the plot is going to be larger than  one  page,
       it  will automatically be spread over as many pages as are
       required.

       PostScript is a printer language  for  describing  printed
       pages.  Printers  that accept PostScript include the Apple
       LaserWriters,  QMS  PS-  series   printers,   DataProducts
       LZR-2665  and 2660 and the Linotronic 100 and 300 typeset-
       ters.  PostScript is a trademark of Adobe Systems Incorpo-
       rated. The ghostscript program can convert PostScript to a
       variety of printer formats if a PS printer is  not  avail-
       able.  (Ghostscript  can  also be used to preview plots on
       the display.)

       Bezier splines are used to calculate interpolating  curves
       between  the  points.   In  some  case the process may not
       deliver a smooth curve, and  you  will  have  to  use  the
       straight-line plot option (--ss).

       pplloottffooiill  can  also  account for sheeting. If the wing you
       are building is to be sheeted, the ribs or templates  need
       to  be inset from the required surface by the thickness of
       the sheet. The airfoil outline is plotted  with  a  dotted
       line, and the template line is drawn with a solid line.




                            Feb. 1992                           1





plotfoil(1l)                                         plotfoil(1l)


OOPPTTIIOONNSS
       Under  MS-DOS, the ``/'' can be used as the option charac-
       ter instead of the ``-''.

       --cc     Sets the chord of the section to plot. The argument
              is  the chord, in units of either mm, cm or inches.
              The units are specified by a trailing `m', `c',  or
              `i',  with the default of mm being used if unspeci-
              fied.

       --ss     This flag indicates that for _x  values  of  greater
              than  2.5%,  straight  lines should be used to join
              the points. This results in a PostScript file which
              is  probably  just as good but should print in less
              time. The limit (2.5%) can be changed with  the  --ll
              option.

       --ll     This  option  changes  the  limit  used with the --ss
              option. It takes the percentage-chord as  argument.

       --pp     This  invokes  the  interactive mode where plotfoil
              will prompt you for all the paramters of the  plot.
              If  plotfoil  is  invoked  without  an arguments it
              automatically enters prompt mode.

       --ii     This option draws the section inset by  the  speci-
              fied  amount,  which  is  what you would use if the
              wing you are building is sheeted. The units default
              to those used for the chord.

       --sspp    This  option  adds a spar to the plot. It takes two
              arguments, the offset (expressed as a percentage of
              the  chord)  and the thickness of the spar (default
              units: same as used for the chord). This option can
              be  used multiple times to draw more than one spar.
              Also, 0-thickness spars can be used to draw  verti-
              cal lines on the plot.

       --tthh    This  option  sets  the height of the template out-
              line, measured from the chord line. The default  is
              0.

       --ttll

       --tttt    These  options  set  the  horizontal extents of the
              template. The value specified is  the  distance  of
              the  edge of the template from the {leading, trail-
              ing} edge.  The units default  to  those  specified
              while setting the chord. The default value is 0.

              If  any of --tthh, --ttll or --tttt is used, a template will
              be drawn.

       --aa     Turns the section by this many degrees. This useful



                            Feb. 1992                           2





plotfoil(1l)                                         plotfoil(1l)


              for  adding washout or washin. A positive number is
              a rotation in the counter-clockwise direction; neg-
              ative is clockwise.

       --hh     Prints some help information.

       --oo     Writes the output to the specified file.

       --xx     This  option  moves  the drawing on the page to the
              right. Some printers (or ghostscript drivers)  have
              different  ideas  about  what constitutes centered.
              This option can be used for fine-tuning.

       --yy     Same as --xx except that it moves the drawing up.

eeddiittffooiill
       --cc     Modifies the camber to  this  value  (expressed  as
              percent. chord). 0 is valid.

       --tt     Modifies  the thickness to this value (expressed as
              percent. chord).

       --oo     Writes the output to the specified file.

mmiixxffooiillss
       --rr     The interpolation ratio. The generated section will
              be  _r  of  the  second  section  and _(_1_0_0_-_r_) of the
              first. If you have one  section  at  the  root  and
              another  at  the  tip,  to  find the section at 70%
              semi-span out you would use 70.

       --oo     Writes the output to the specified file.

IINNPPUUTT FFOORRMMAATTSS
       There are two formats for  pplloottffooiill  input  data,  distin-
       guished  by  how coordinates are specified. The first line
       of the file is taken to be the name of the section and  is
       printed along with the plot.

       The  smallest  _x  value  (usually 0.0) is the L.E. and the
       largest (usually 1.0) is the T.E.

       This is the first format:

          SSDD--88002200
          11..00 00
          00..99 00..001111
          00..8855 00..0022
          ......
          11..00 00

       Note: it starts at _x=1.0 (the trailing edge), goes  around
       and  ends again at the T.E. This is the format used by the
       sections in Soartech 8.



                            Feb. 1992                           3





plotfoil(1l)                                         plotfoil(1l)


       This is the second format:

          CCllaarrkk YYHH
          00 00 00
          00..00112255 00..00440099 --00..00118833
          00..002255 ..00552299 --..00227711
          ......
          11..00 00 00

       This starts at the L.E. and ends at  the  T.E.,  with  the
       columns being the upper and lower ordinate values. This is
       the format that most of the NACA sections  were  published
       in.

       eeddiittffooiill and mmiixxffooiillss both print data in the first format.

EEXXAAMMPPLLEESS
       This command:

              pplloottffooiill --cc 2200cc --ii 22mm --sspp 3322 00..22 ssdd88002200 || llpprr

       will plot the SD-8020 section with a chord of 20cm, with a
       sheeting  allowance  of  2mm,  and  a spar 2mm wide at 32%
       chord. The name of the section and the sheeting  allowance
       are also printed.

              pplloottffooiill  --cc  88..55ii  --ii 00..112255 --ss --ll 1100 --oo ccllaarrkkYYHH..ppss
              ccllaarrkkYYHH

       will plot the Clark YH with a chord of  8.5  inches.  Only
       the area from the L.E.  to 10% back will interpolated with
       splines, and from 10% to the T.E.; straight lines will  be
       used to connect the points. A sheeting allowance of 0.125"
       (1/8") will also be drawn. The PostScript will be left  in
       "clarkYH.ps".

              pplloottffooiill  --cc  445500mm --ii 11 --sspp 55 00..55 --sspp 3300 22..55 --tthh 7700
              --tttt 1100 --ttll 1100 --xx --11..55cc --oo rrgg1155..ppss RRGG--1155

       This plots the RG-15 airfoil with a chord of 450mm.  Since
       this  is too large to fit on one page it will be automati-
       cally split across two pages. A sheeting allowance of  1mm
       is  printed,  and  there  are two spars: one at 30% that's
       2.5mm thick, and another at 5% that's very narrow, i.e.  a
       LE  marking.   A  rectangular template is drawn around the
       plot; and all the graphics are moved to the _l_e_f_t by 1.5cm,
       i.e.  negative numbers can be used in the positioning. The
       PostScript is saved in "rg15.ps".

              eeddiittffooiill --cc 00 --oo ssyymmmmeettrriicc..aaiirrffooiill SSDD--77003377

       Construct a symmetric airfoil from the SD-7037 and save as
       "symmetric.airfoil".




                            Feb. 1992                           4





plotfoil(1l)                                         plotfoil(1l)


              eeddiittffooiill  --tt 77 --cc 11..55 RRGG--1155 || pplloottffooiill --cc 440000mm --ii 11
              --sspp 3300 11..55 || llpprr

       Plot a thinned down (7%) de-cambered (1.5%) RG-15.

              mmiixxffooiillss --rr 7755 --oo mmiixxeedd--aaiirrffooiill SSDD--77003377 SSDD--77003322

       Generate a section that is 25% SD-7037 and 75% SD-7032.

DDIISSTTRRIIBBUUTTIIOONN
       pplloottffooiill, eeddiittffooiill  and  mmiixxffooiillss  are  free;  anyone  may
       redistribute copies of it to anyone under the terms stated
       in the Gnu General Public License version  2,  a  copy  of
       which should accompany each copy of plotfoil. See the file
       ``COPYING'' in the source area. If you do  not  have  this
       file, a copy may be obtained from the author, or from:
          Free Software Foundation
          1000 Mass Ave.
          Cambridge, MA 02138
       or from the author.

       Also,  if  you  make any changes to these programs and re-
       distribute them, the same conditions apply to the modified
       version  so  that  we  can all benefit from it. And please
       send me those changes!

AAUUTTHHOORR
       Shamim Mohamed (shamim@math.isu.edu)
       Dept of Mathematics
       Idaho State University
       Pocatello, ID 83209

BBUUGGSS
       On some printers, there may be a  stack  overflow  if  the
       plot  is  on  more than one page and there are more than a
       certain number of coordinate values. If this happens, try

              a) finding another printer, or

              b) removing some of the airfoil data.

       In the latter case you may still get satisfactory  results
       because of the smooth interpolation used.

       Since  the  program  doesn't know how big the printer page
       size is, it can get confused. This should only err conser-
       vatively,  like  producing an extra blank page on a multi-
       page plot. As long as the page is  higher  than  about  11
       inches  (27  cm)  everything should be fine. If you have a
       compiler, adjust the values in pplloottffooiill..hh and recompile.

       I don't know of any other bugs right now, but please  send
       all  bug  reports  to  me.  Include version number and the
       exact details (input files, command-line  options   etc.),



                            Feb. 1992                           5





plotfoil(1l)                                         plotfoil(1l)


       please.
























































                            Feb. 1992                           6



