
/*
 * Does prompting for plotfoil.
 */

#include "plotfoil.h"
#include "externs.h"

static char *banner = "Welcome to the interactive interface to plotfoil.\n\n";

static void get_str(char *, char *);
static int get_pct(char *);
static char get_char(char *, char *);
static void read_value(char *prompt, char units, value_t *v);
static float get_float(char *prompt);

void prompt_mode()
{
   char ans, raw_units;
   int raw_off;
   char outfile[TXTSIZ], infile[TXTSIZ];
   FILE *f_in;
   airfoil_data_t info;

   fputs(copyright, stdout);
   fputs(banner, stdout);

   for(;;) {
      get_str("Type the name of the airfoil data file: ", infile);
      if(!(f_in = fopen(infile, "r")))
	 printf("Couldn't open \"%s\" for reading!\n", infile);
      else
	 break;
   }

   for(;;) {
      get_str("Type a filename to save the output in: ", outfile);
      if(!(fout = fopen(outfile, "w")))
	 printf("Couldn't open \"%s\" for writing!\n", outfile);
      else
	 break;
   }
   
   raw_units = get_char("What units will you be using? ", "mic");
   read_value("What chord would you like to plot? ", raw_units, &chord);

   ans = get_char("Do you want to allow for sheeting thickness?", "yn");
   if(ans == 'y') {
      iflag++;
      read_value("What is the thickness of the sheeting? ", raw_units,
		 &sheeting);
   }
   
   ans = get_char("Do you want a rectangular template outline?", "yn");
   if(ans == 'y') {
      tflag++;
      read_value("Template height above and below the mean chord line: ",
		raw_units, &templ_h);
      read_value("How far in front of the LE should it extend? ", raw_units,
		&templ_le);
      read_value("How far behind the TE should it extend? ", raw_units,
		&templ_te);
   }

   ans = get_char("Do you want to plot any spars?", "yn");
   if(ans == 'y') {
      do {
	 raw_off = get_pct("At what % chord is the spar? ");
	 spars[nspars].offset = raw_off/100.0;
	 read_value("What thickness is this spar? ", raw_units,
		    &spars[nspars].thick);
	 nspars++;
	 ans = get_char("Another spar?", "yn");
      } while(ans == 'y');
   }

   ans = get_char("Do you want to slant the plot?", "yn");
   if(ans == 'y') {
      angle = get_float("Enter angle in degrees (- clockwise, + ccw) ");
      aflag++;
   }

   ans = get_char("Do you need to reposition the plot on the paper?", "yn");
   if(ans == 'y') {
      read_value("Move to the right by: ", raw_units, &xfudge);
      read_value("Move up by: ", raw_units, &yfudge);
   }
   
   /*
   ans = get_char("Do you want to change the straight line default? ", "ny");
   if(ans == 'y') {
      sflag++;
      s_limit = get_float("Plot straight lines for x greater than: ");
   }
   */

   if(!(read_foil(f_in, infile, &info)))
      return;
   plot(&info);
}

static void read_value(char *prompt, char units, value_t *v)
{
   char buffer[TXTSIZ], this_unit, *p;
   
   for(;;) {
      fputs(prompt, stdout);
      fflush(stdout);
      fgets(buffer, TXTSIZ, stdin);
      if((p = strchr(buffer, '\n')) != 0)
	 *p = 0;
      p = buffer;
      if(*p == '-') 
	 p++;
      if(!isdigit(*p)) {
	 fputs("Numeric argument required.\n", stdout);
	 continue;
      }
      while(isdigit(*p) || (*p == '.'))
	 p++;
      this_unit = *p;
      if(!(this_unit == 0 || strchr("mic", this_unit))) {
	 printf("Unknown unit suffix `%c'.\n", this_unit);
	 continue;
      }
      *p = 0;
      if(sscanf(buffer, "%f", &v->raw_value) == 1)
	 break;
   }
   if(!this_unit)
      this_unit = units;
   switch((int)this_unit) {
   case 'i':
      v->scale = 72.0; v->units = "\""; break;
   case 'c':
      v->scale = 28.34; v->units = "cm"; break;
   case 'm':
   default:
      v->units = "mm"; v->scale = 2.834; break;
   }
   v->pts = v->raw_value * v->scale;
}

static int get_pct(char *s)
{
   char buffer[TXTSIZ];
   char *p;
   int value;
   
   for(;;) {
      fputs(s, stdout);
      fflush(stdout);
      fgets(buffer, TXTSIZ, stdin);
      if((p = strchr(buffer, '\n')) != 0)
	 *p = 0;
      p = buffer;
      while(*p && isdigit(*p))
	 p++;
      if(*p || (value = atoi(buffer)) > 100) {
	 fputs("Need a number between 0 and 100, please!\n", stdout);
	 continue;
      }
      return value;
   }
}

static float get_float(char *prompt)
{
   char buffer[TXTSIZ];
   char *p;
   float value;
   int sign = 1;
   
   fputs(prompt, stdout);
   fflush(stdout);
   fgets(buffer, TXTSIZ, stdin);
   if((p = strchr(buffer, '\n')) != 0)
      *p = 0;
   p = buffer;
   if(*p == '-') {
      sign = -1;
      p++;
   }
   if(*p == '+')
      p++;
   value = (float) atof(p);

   return sign * value;
}

static void get_str(char *prompt, char *reply)
{
   char *p;
   fputs(prompt, stdout);
   fgets(reply, TXTSIZ, stdin);
   if((p = strchr(reply, '\n')) != 0)
      *p = 0;
}


static char get_char(char *prompt, char *valid)
{
   char buffer[TXTSIZ], *p;

   for(;;) {
      printf("%s [%s] ", prompt, valid);
      fgets(buffer, TXTSIZ, stdin);
      if((p = strchr(buffer, '\n')) != 0)
	 *p = 0;
      if(!buffer[0])
	 return valid[0];
      if(strchr(valid, buffer[0]))
	 return buffer[0];
      printf("Valid replies are <%s>!\n", valid);
   }
}
