import java.net.*;
import java.io.*;
import java.util.*;

class WWWUtil {
    final static String version = "1.0";
    final static String mime_text_plain = "text/plain";
    final static String mime_text_html = "text/html";
    final static String mime_image_gif = "image/gif";
    final static String mime_image_jpg = "image/jpg";
    final static String mime_app_os = "application/octet-stream";
    final static String CRLF = "\r\n";

    public static byte toBytes(String s)[] {
        byte b[] = new byte[s.length()];
        s.getBytes(0,b.length,b,0);
        return b;
    }

    public static byte byteArrayConcat(byte a[], byte b[])[] {
	byte ret[] = new byte[a.length + b.length];
	System.arraycopy(a,0,ret,0,a.length);
	System.arraycopy(b,0,ret,a.length,b.length);
	return ret;
    }

    public static byte mimeHeader(String ct, int size)[] {
        return mimeHeader(200, "OK", ct, size);
    }

    public static byte mimeHeader(int code, String msg,
				  String ct, int size)[] {
        Date d = new Date();
        return toBytes("HTTP/1.0 " + code + " " + msg + CRLF +
		       "Date: " + d.toGMTString() + CRLF +
		       "Server: Java/" + version + CRLF +
		       "Content-type: " + ct + CRLF +
		       (size > 0 ?
			"Content-length: " + size + CRLF :
			"") +
		       CRLF);
    }

    public static byte error(int code, String msg, String fname)[] {
        String ret = "<body>" + CRLF + "<h1>" + code + " " + msg + "</h1>" + CRLF;
        if (fname != null) 
            ret += "Error when fetching URL: " + fname + CRLF;
	ret += "</body>" + CRLF;
	byte tmp[] = mimeHeader(code, msg, mime_text_html, 0);
        return byteArrayConcat(tmp,toBytes(ret));
    }

    public static String mimeTypeString(String filename) {
        String ct;
        if (filename.endsWith(".html") || filename.endsWith(".htm"))
            ct = mime_text_html;
        else if (filename.endsWith(".class"))
            ct = mime_app_os;
        else if (filename.endsWith(".gif"))
            ct = mime_image_gif;
        else if (filename.endsWith(".jpg"))
            ct = mime_image_jpg;
        else
            ct = mime_text_plain;
        return ct;
    }
}

class HTTPlog {
    public static void error(String entry) {
        System.out.println("Error: " + entry);
    }
    public static void request(String request) {
        System.out.println(request);
    }
}

class thttp {
    public static final int port=80;
    final static String docRoot = "/html";
    final static String indexfile = "index.html";
    final static int buffer_size = 2048;

    public static final int RT_GET=1;
    public static final int RT_UNSUP=2;
    public static final int RT_END=4;

    private static void handleUnsup(String request,
				    OutputStream out) {
        HTTPlog.error("Unsupported Request: " + request);
    }

    private static void handleGet(String request,
				  OutputStream out) {
        int fsp = request.indexOf(' ');
        int nsp = request.indexOf(' ',fsp+1);
        String filename = request.substring(fsp+1,nsp);
        filename = docRoot + filename + 
	    (filename.endsWith("/") ? indexfile : "");
        try {
            File f = new File(filename);
            if (! f.exists()) {
                out.write(WWWUtil.error(404,"Not Found", filename));
                return;
            }
            if (! f.canRead()) {
                out.write(WWWUtil.error(404,"Permission Denied",filename));
                return;
            }

            InputStream input = new FileInputStream(f);
            String mime_header = WWWUtil.mimeTypeString(filename);
	    int n = input.available();
            out.write(WWWUtil.mimeHeader(mime_header, n));
            byte buf[] = new byte[buffer_size];
            while ((n = input.read(buf)) >= 0) {
                out.write(buf,0,n);
            }
            input.close();
        } catch (IOException e) {
            HTTPlog.error("Exception: " + e);
        }
    }

    private static String getRawRequest(InputStream in) {
        try {
            byte buf[] = new byte[buffer_size];
            boolean gotCR=false;
            int pos=0;
            int c;
            while ((c = in.read()) != -1) {
                switch (c) {
		  case '\r':
		    break;
		  case '\n': 
		    if (gotCR)
			return new String(buf,0,0,pos);
		    gotCR = true;
		    // FALLSTHROUGH (put the 1st \n in the string)
		  default:
		    if (c != '\n') gotCR = false;
		    buf[pos++] = (byte) c;
                }
            }
        } catch (IOException e) {
            HTTPlog.error("Receive Error");
        }
        return null;
    }

    private static int HTTPRequestType(String request) {
        return request.regionMatches(true,0,"get ",0,4) ? RT_GET : RT_UNSUP;
    }
    
    public static void main(String args[]) throws Exception {
        ServerSocket acceptSocket = new ServerSocket(port);
        while (true) {
            String request;
            Socket s = acceptSocket.accept();
            OutputStream output = s.getOutputStream();
            InputStream input = s.getInputStream();

	    if ((request = getRawRequest(input)) != null) {
                switch (HTTPRequestType(request)) {
		  case RT_GET:
		    handleGet(request,output);
		    break;
		  case RT_UNSUP:
		  default:
		    handleUnsup(request,output);
		    break;
                }
                HTTPlog.request(request);
            }
	    input.close();
	    output.close();
	    s.close();
        }
    }
}




