
import java.applet.*;
import java.awt.*;

public class FontMetricTest extends Applet {

    int fontSize;
    String labelString, fontName;


    public void init() {
        fontName = getParameter("fontName");
        labelString = getParameter("labelString");
        if(fontName==null) {
            fontName="Courier";
        }
        if(labelString==null) {
            labelString="Yoppo";
        }
    }

    public void paint(Graphics g) {
        Dimension d = this.size();
        fontSize=(int) (d.height*.8);

        g.setFont(new Font(fontName, Font.PLAIN, fontSize));

        drawBoxedCenteredString(labelString, d.width, d.height, g);
        g.drawRect(0,0,d.width-1,d.height-1);
    }

    public void drawBoxedCenteredString(String s, int w, int h, Graphics g) {
        FontMetrics fm = g.getFontMetrics();

        System.out.println(fm.toString());

        int stringWidth = fm.stringWidth(s);

        int x = (w - stringWidth) / 2;
        int baseline = fm.getAscent() +
                           (h - (fm.getAscent() + fm.getDescent()))/2;
        int ascent  = fm.getAscent();
        int descent = fm.getDescent();
        int leading = fm.getLeading();
        int fontHeight = fm.getAscent() + fm.getDescent();

        g.setColor(Color.white);
        g.fillRect(x, baseline-ascent , stringWidth, fontHeight);

        g.setColor(Color.gray);
        g.drawLine(x, baseline, x+stringWidth, baseline);

        g.setColor(Color.red);
        g.drawLine(x, baseline+descent, x+stringWidth, baseline+descent);

        g.setColor(Color.blue);
        g.drawLine(x, baseline-ascent,
                   x+stringWidth, baseline-ascent);
        g.setColor(Color.black);
        g.drawString(s, x, baseline);
    }
}


