
import java.applet.*;
import java.awt.*;

public class MaxFontMetricTest extends Applet {

    int fontSize;
    String labelString;


    public void init() {
        labelString = getParameter("labelString");
        System.out.println("label = " + labelString);
        if(labelString==null) {
            labelString="Yoppo";
        }
        System.out.println("label 2= " + labelString);
    }

    public void paint(Graphics g) {
        Dimension d = this.size();
        fontSize=(int) (d.height*.8);

        g.setFont(new Font("TimesRoman", Font.PLAIN, fontSize));

        drawBoxedCenteredString(labelString, d.width, d.height, g);
        g.drawRect(0,0,d.width-1,d.height-1);
    }

    public void drawBoxedCenteredString(String s, int w, int h, Graphics g) {
        FontMetrics fm = g.getFontMetrics();

        showStatus(fm.toString());

        int stringWidth = fm.stringWidth(s);

        int x = (w - stringWidth) / 2;
        int baseline = fm.getMaxAscent() +
                           (h - (fm.getAscent() + fm.getMaxDecent()))/2;
        int ascent  = fm.getMaxAscent();
        int descent = fm.getMaxDecent();
        int fontHeight = fm.getMaxAscent() + fm.getMaxDecent();

        g.setColor(Color.white);
        g.fillRect(x, baseline-ascent , stringWidth, fontHeight);

        g.setColor(Color.gray);
        g.drawLine(x, baseline, x+stringWidth, baseline);

        g.setColor(Color.red);
        g.drawLine(x, baseline+descent, x+stringWidth, baseline+descent);

        g.setColor(Color.blue);
        g.drawLine(x, baseline-ascent,
                   x+stringWidth, baseline-ascent);
        g.setColor(Color.black);
        g.drawString(s, x, baseline);
    }
}


