
import java.applet.*;
import java.awt.*;

public class Polydrawer extends Applet {

    boolean drawing = false;
    int xArray[] = new int[1000];
    int yArray[] = new int[1000];
    int point;

    public void paint(Graphics g) {
        Dimension d = this.size();

        g.setColor(Color.blue);
        if (drawing && (point>1)) {
        showStatus("drawing " + point);
            g.drawPolygon(xArray, yArray, point);
        }
        else if (point>1) {
        showStatus("filling " + point);
            g.drawPolygon(xArray, yArray, point);
        }
        showStatus("aint drawn yet: " + point);
    }
    public void clearPoints(int x, int y) {
        point = 0;
        addPoint(x, y);
    }

    synchronized public void addPoint(int x, int y) {
        xArray[point] = x;
        yArray[point] = y;
        point++;
    }

    public boolean mouseExit(java.awt.Event evt, int x, int y) {
        drawing = false;
        repaint();
        return true;
    }
    public boolean mouseDown(java.awt.Event evt, int x, int y) {
        drawing = true;
        clearPoints(x, y);
        addPoint(x, y);
        repaint();
        return true;
    }
    public boolean mouseDragged(java.awt.Event evt, int x, int y) {
        addPoint(x, y);
        repaint();
        return true;
    }
    public boolean mouseUp(java.awt.Event evt, int x, int y) {
        drawing = false;
        repaint();
        return true;
    }
}


