
import java.applet.*;
import java.awt.*;

public class SolarisFontMetricTest extends Applet {

    int fontSize;
    String labelString;


    public void init() {
        labelString = getParameter("labelString");
        System.out.println("label = " + labelString);
        if(labelString==null) {
            labelString="Yoppo";
        }
        System.out.println("label 2= " + labelString);
    }

    public void paint(Graphics g) {
        Dimension d = this.size();
        fontSize=(int) (d.height*.8);

        g.setFont(new Font("TimesRoman", Font.PLAIN, fontSize));

        drawBoxedCenteredString(labelString, d.width, d.height, g);
        g.drawRect(0,0,d.width-1,d.height-1);
    }

    public void drawBoxedCenteredString(String s, int w, int h, Graphics g) {
        FontMetrics fm = g.getFontMetrics();

        showStatus(fm.toString());

        int stringWidth = fm.stringWidth(s);

        int x = (w - stringWidth) / 2;
        int baseline = fm.getAscent() +
                           (h - (fm.getAscent() + fm.getDescent()))/2;
        int ascent  = fm.getAscent();
        int leading = fm.getLeading();
        int descent = fm.getDescent();
        int fontHeight = fm.getAscent() + fm.getDescent();

        g.setColor(Color.white);
        g.fillRect(x, baseline-ascent , stringWidth, fontHeight);

        g.setColor(Color.gray);
        g.drawLine(x, baseline, x+stringWidth, baseline);

        g.setColor(Color.red);
        g.drawLine(x, baseline+descent-leading,
                   x+stringWidth, baseline+descent-leading);

        g.setColor(Color.blue);
        g.drawLine(x, baseline-ascent+descent-leading,
                   x+stringWidth, baseline-ascent+descent-leading);
        g.setColor(Color.black);
        g.drawString(s, x, baseline);
    }
}


