/* <title>Text Layout</title>
 * 
 * <applet code="TextLayout" width=200 height=400>
 *  <param name="text" value="Hello <P> World">
 *  <param name="fontname" value="TimesRoman">
 *  <param name="fontSize" value="18">
 * </applet>
 */

import java.applet.*;
import java.awt.*;
import java.util.*;
import java.lang.*;

public class TextLayout extends Applet {

    final int LEFT = 0;
    final int RIGHT = 1;
    final int CENTER = 2;
    final int LEFTRIGHT =3;
    int align;

    Dimension d;
    Font f;
    FontMetrics fm;
    int fontSize;

    int fh, bl;

    String text;

    public void init() {
        setBackground(Color.white);
        text = getParameter("text");
        try{fontSize = Integer.parseInt(getParameter("fontSize"));}
        catch (NumberFormatException e) {fontSize=14;}
        align = LEFT;
    }

    public void paint(Graphics g) {
        update(g);
    }

    public void update(Graphics g) {
        d = size();

        g.setColor(getBackground());
        g.fillRect(0,0,d.width, d.height);
        g.setFont(new Font(getParameter("fontname"), Font.PLAIN, fontSize));
        fm = g.getFontMetrics();
        bl = fm.getAscent();
        fh = bl + fm.getDescent();

        g.setColor(Color.black);

        StringTokenizer st = new StringTokenizer(text);
        int x = 0;
        int nextx;
        int y = 0;
        int space = fm.stringWidth(" ");
        String word, sp;
        int wordCount = 0;
        String line = "";

        while (st.hasMoreTokens()) {
            word = st.nextToken();

            if(word.equals("<P>")) {
                drawString(g, line, wordCount, fm.stringWidth(line), y+bl);
                line = "";
                wordCount = 0;
                x = 0;
                y = y + (fh * 2);
            }
            else {
                int w = fm.stringWidth(word);
                if( ( nextx = (x+space+w)) > d.width ) {
                    drawString(g, line, wordCount, fm.stringWidth(line), y+bl);
                    line = "";
                    wordCount = 0;
                    x = 0;
                    y = y + fh;
                }
                if (x!=0) {sp = " ";} else {sp = "";}
                line = line + sp + word;
                x = x + space + w;
                wordCount++;
            }
        }
        drawString(g, line, wordCount, fm.stringWidth(line), y+bl);
    }

    public void drawString(Graphics g, String line, int wc, int lineW, int y) {
        switch(align) {
	  case LEFT:    g.drawString(line, 0, y);
                        break;
	  case RIGHT:   g.drawString(line, d.width-lineW ,y);
                        break;
	  case CENTER:  g.drawString(line, (d.width-lineW)/2, y);
                        break;
	  case LEFTRIGHT:
                        if(lineW < (int)(d.width*.75)) {
                            g.drawString(line, 0, y);
                        }
                        else {
                            int toFill = (int)((d.width - lineW)/wc);
                            int nudge = d.width - lineW - (toFill*wc);
                            
                            FontMetrics fm = g.getFontMetrics();
                            int s = fm.stringWidth(" ");
                            StringTokenizer st = new StringTokenizer(line);
                            int x = 0;

                            while(st.hasMoreTokens()) {
                                String word = st.nextToken();
                                g.drawString(word, x, y);
                                if(nudge>0) {
                                   x = x + fm.stringWidth(word) + s + toFill+1;
                                   nudge--;
			       }
			       else {
                                   x = x + fm.stringWidth(word) + s + toFill;
			       }
                            }
                        }
                        break;
        }
    }

    public boolean mouseUp(java.awt.Event evt, int x, int y) {
        align = (align + 1) % 4;
        repaint();
        return true;
    }
}


