/* <title>FunImageAnim</title>
 * 
 * <applet code="FunImageAnim" width=100 height=100>
 *  <param name="img" value="jhanim.gif">
 * </applet>
 */

import java.applet.*;
import java.awt.*;
import java.awt.image.*;

public class FunImageAnim extends Applet implements Runnable, ImageObserver {

    Image art, offScreen;
    Graphics offScreenGraphics;
    Dimension d;
    int progress;

    int frame, frames, framerate;
    int pause;
    int sleep;

    Thread motor;
    boolean loaded;

    public void init() {
        art = getImage(getDocumentBase(), getParameter("img"));
        framerate = (int) (1000/(Integer.parseInt(getParameter("fps"))));
        pause = 1000 * (Integer.parseInt(getParameter("pause")));
        loaded = false;
        progress = 0;
        frame=0;
        frames=12;
    }

    public void paint(Graphics g) {
        update(g);
    }

    public void update(Graphics g) {
        if(d==null) {
            d = this.size();
            offScreen = createImage(d.width, d.height);
            offScreenGraphics = offScreen.getGraphics();
        }
    
        loaded = offScreenGraphics.drawImage(art, -1*frame*d.width, 0, this); 

        if(loaded) {
            g.drawImage(offScreen, 0, 0, null);
        }
        else {
            g.setColor(Color.gray);
            g.fillRect(0, 0, progress, d.height);
            g.drawRect(0, 0, d.width-1, d.height-1);
        }
            
    }

    public boolean imageUpdate(Image img, int info, int x, int y, int w, int h) {

        if( (info & ALLBITS) != 1 ) {
            if(progress<d.height) {
                progress = progress + h;
            }
            return(true);
        }
        else {
            frames = 12; //w / d.width;
            return(false);
        }
    }

    public void start() {
	motor = new Thread(this);
        motor.start();
    }

    public void stop() {
        motor.stop();
    }

    public void run() {
        motor.setPriority(Thread.MIN_PRIORITY);

        while(true) {
            repaint();
            if(frame==0) { sleep=pause; } else { sleep=framerate; }
            try {motor.sleep(sleep);} catch (InterruptedException e) {}
            frame = (frame + 1) % frames;
        }
    }       
}


