/* <title>FunImageLoad</title>
 * 
 * <applet code="ObservedImageLoad" width=200 height=200>
 *  <param name="img" value="alex.gif">
 * </applet>
 */

import java.applet.*;
import java.awt.*;
import java.awt.image.*;

public class FunImageLoad extends Applet implements Runnable, ImageObserver {

    Image art, offScreen;
    Graphics offScreenGraphics;
    Dimension d;
    int progress;

    Thread motor;
    boolean loaded;

    public void init() {
        art = getImage(getDocumentBase(), getParameter("img"));
        loaded = false;
        progress = 0;
    }

    public void paint(Graphics g) {
        update(g);
    }

    public void update(Graphics g) {
        if(d==null) {
            d = this.size();
            offScreen = createImage(d.width, d.height);
            offScreenGraphics = offScreen.getGraphics();
        }
    
        loaded = offScreenGraphics.drawImage(art, 0, 0, this); 

        if(loaded) {
            g.drawImage(offScreen, 0, 0, null);
        }
        else {
            g.setColor(Color.gray);
            g.fillRect(0, 0, progress, d.height);
            g.drawRect(0, 0, d.width-1, d.height-1);
        }
            
    }

    public boolean imageUpdate(Image img, int info, int x, int y, int w, int h) {

        if( (info & ALLBITS) != 1 ) {
            if(progress<d.height) {
                progress = progress + h;
            }
            return(true);
        }
        else {
            return(false);
        }
    }

    public void start() {
	motor = new Thread(this);
        motor.start();
    }

    public void stop() {
        motor.stop();
    }

    public void run() {
        motor.setPriority(Thread.MIN_PRIORITY);
        while(!loaded) {
            repaint();
            try {motor.sleep(200);} catch (InterruptedException e) {}
        }
    }       
}


