/* <title>ImageFilterTest</title>
 * 
 * <applet code="ImageFilterTest" width=400 height=200>
 *  <param name="img" value="alex.gif">
 * </applet>
 */

import java.applet.*;
import java.awt.*;
import java.awt.image.*;

public class ImageFilterTest extends Applet
             implements Runnable, ImageObserver {

    Image art, img, offScreen;
    Graphics offScreenGraphics;
    Dimension d;
    int progress;
    boolean filterstart = false;

    Thread motor;
    boolean loaded;

    public void init() {
        art = getImage(getDocumentBase(), getParameter("img"));
        loaded = false;
        progress = 0;
    }

    public void paint(Graphics g) {
        update(g);
    }

    public void update(Graphics g) {
        if(d==null) {
            d = this.size();
            offScreen = createImage(d.width, d.height);
            offScreenGraphics = offScreen.getGraphics();
        }
    
        loaded = offScreenGraphics.drawImage(art, 0, 0, this); 
//        offScreenGraphics.drawImage(img, 200, 0, null);

        if(loaded) {
            if(!filterstart) doFilter();
            g.drawImage(art, 0, 0, null);
            g.drawImage(img, 200, 0, null);
        }
        else {
            g.setColor(Color.gray);
            g.fillRect(0, 0, progress, d.height);
            g.drawRect(0, 0, d.width-1, d.height-1);
        }
    }


    public void doFilter() {
        Image src = art;
        ImageFilter colorfilter = new ColorFilter();
        img = createImage(new FilteredImageSource(src.getSource(),
                                                        colorfilter));
        filterstart = true;

    }

    public boolean imageUpdate(Image img, int info,
                               int x, int y, int w, int h) {

        if( (info & ALLBITS) != 1 ) {
            if(progress<d.height) {
                progress = progress + h;
            }
            return(true);
        }
        else {
            return(false);
        }
    }

    public void start() {
	motor = new Thread(this);
        motor.start();
    }

    public void stop() {
        motor.stop();
    }

    public void run() {
        motor.setPriority(Thread.MIN_PRIORITY);
        while(true) { //!loaded) {
            repaint();
            try {motor.sleep(500);} catch (InterruptedException e) {}
        }
    }       
}


class ColorFilter extends RGBImageFilter {

    public ColorFilter() {
        // The filter's operation does not depend on the
        // pixel's location, so IndexColorModels can be
        // filtered directly.
        canFilterIndexColorModel = true;
    }
    public int filterRGB(int x, int y, int rgb) {
       
        return ((rgb & 0xff0000ff)
                | ((rgb & 0xff0000) >> 8)
                | ((rgb & 0xff00) << 8));
    }
}
