/* <title>Memory Image Generator</title>
 * 
 * <applet code="MemoryImageGenerator" width=256 height=256>
 * </applet>
 */

import java.applet.*;
import java.awt.*;
import java.awt.image.*;

public class MemoryImageGenerator extends Applet {

    Image art;
    int w, h;

    public void init() {
        w = h = 300;
        generateImage();
    }

    public void generateImage() {
        int pixels[] = new int[w * h];
        int i = 0;
        int r, g, b;

        for(int y=0; y<h; y++) {
            for(int x=0; x<h; x++) {
                r = (x^y)&0xff;
                g = (x*2^y*2)&0xff;
                b = (x*4^y*4)&0xff;
                pixels[i++] = (255 << 24) | (r << 16) | (g << 8) | b;
            }
        }

        art = createImage(new MemoryImageSource(w,h,pixels,0,w));
    }

    public void paint(Graphics g) {
        g.drawImage(art, 0, 0, this);
    }
}


