/* <title>TrackedImageLoad</title>
 * 
 * <applet code="TrackedImageLoad" width=200 height=200>
 *  <param name="img" value="alex.gif">
 * </applet>
 */

import java.applet.*;
import java.awt.*;

public class TrackedImageLoad extends Applet implements Runnable {

    MediaTracker tracker;
    int tracked;
    Thread motor;
    boolean hack;

    Image art, foo;

    public void init() {
        tracker = new MediaTracker(this);
        tracked = 0;
        hack = true;
        art = getImage(getDocumentBase(), getParameter("img"));
        tracker.addImage(art, tracked++);
    }

    public void paint(Graphics g) {
        if(imagesLoaded()) {
            g.drawImage(art, 0, 0, null);
            hack = false;
        }
    }

    public boolean imagesLoaded() {
	boolean loaded = false;
        for(int i=0; i<tracked; i++) {
            loaded = (tracker.checkID(i, true))? true: false;
            System.out.println(i + ": " + (loaded?"done":"loading"));
        }
        return(loaded);
    }

    public void start() {
	motor = new Thread(this);
        motor.start();
    }

    public void stop() {
        motor.stop();
    }

    public void run() {
        motor.setPriority(Thread.MIN_PRIORITY);
        while(hack) {
            repaint();
            try {motor.sleep(200);} catch (InterruptedException e) {}
        }
    }       
}

