/*
<applet code="Poetry.class" width=400 height=400>
<param name=words value="beautiful,the,fluffy,and,not,a,puppy,we,go,out,on,lake,for,meat,milk,poetry,enormous,but,love,you,friend,I">
</applet>
*/

import java.util.StringTokenizer;
import java.awt.*;
import java.applet.Applet;

class Node {
    int x;
    int y;
    int w;
    int h;
    String lbl;

    void move(int x, int y) {
	this.x = x;
	this.y = y;
    }
    void rmove(int x, int y) {
	this.x += x;
	this.y += y;
    }
    boolean hit(int xp, int yp) {
	return (xp >= x && xp < x + w && yp >= y && yp < y + h);
    }
    boolean oneDoverlap(int a, int b, int c, int d) {
	return (a < d && b > c);
    }
    boolean overlap(Node n) {
	boolean xo = oneDoverlap(n.x, n.x + n.w, x, x + w);
	boolean yo = oneDoverlap(n.y, n.y + n.h, y, y + h);
	return xo && yo;
    }
    void adjust(Node n, int ox, int oy) {
	rmove(n.x - ox, n.y - oy);
    }
    boolean pressed = false;

    void paint(Graphics g, Color c, Color dark, Color bright) {
	g.setColor(c);
	g.fillRect(x, y, w, h);
	g.setColor(pressed ? dark : bright);
	g.fillRect(x, y, w - 1, 1);
	g.fillRect(x, y + 1, 1, h - 2);
	g.setColor(pressed ? bright : Color.black);
	g.fillRect(x, y + h - 1, w, 1);
	g.fillRect(x + w - 1, y, 1, h - 1);
	if (pressed) {
	    g.setColor(Color.black);
	    g.fillRect(x + 1, y + 1, w - 3, 1);
	    g.fillRect(x + 1, y + 2, 1, h - 4);
	} else {
	    g.setColor(dark);
	    g.fillRect(x + 1, y + h - 2, w - 2, 1);
	    g.fillRect(x + w - 2, y + 1, 1, h - 3);
	}
    }

    public String toString() {
	return "Node['" + lbl + "' " + x + "," + y +" "+ w + "x" + h + "]";
    }
}

class PoetryPanel extends Panel {
    int nnodes;
    Node nodes[] = new Node[100];
    Node topnodes[] = new Node[100];

    boolean push;
    boolean overlap;
    final int xgap = 5;
    final int ygap = 4;

    PoetryPanel() {
    }

    int findNode(String lbl) {
	for (int i = 0 ; i < nnodes ; i++) {
	    if (nodes[i].lbl.equals(lbl)) {
		return i;
	    }
	}
	return addNode(lbl);
    }

    int addNode(String lbl) {
	Node n = new Node();
	n.lbl = lbl;
	nodes[nnodes] = n;
	return nnodes++;
    }

    Node pick;
    Node oldpick = null;
    Node initover;
    Node over;
    Node oldover = null;
    int dx, dy;
    Dimension offscreensize;
    Image offscreen;
    Graphics offGraphics;
    Image offscreen2;
    Graphics offGraphics2;
    FontMetrics fm;
    boolean pressed = false;

    final Color nodeColor = new Color(250, 220, 100);
    final Color nodeDark = gain(nodeColor, .71);
    final Color nodeBright = gain(nodeColor, 1.31);

    final Color selectColor = Color.pink;
    final Color selectDark = gain(selectColor, .71);
    final Color selectBright = gain(selectColor, 1.31);


    int clamp(double d) {
	return (d < 0) ? 0 : ((d > 255) ? 255 : (int) d);
    }

    Color gain(Color c, double f) {
	return new Color(clamp(c.getRed() * f),
			 clamp(c.getGreen() * f),
			 clamp(c.getBlue() * f));
    }

    public void paintNode(Graphics g, Node n, FontMetrics fm) {
	if (n == pick) {
	    n.paint(g, selectColor, selectBright, selectDark);
	} else {
	    n.paint(g, nodeColor, nodeBright, nodeDark);
	}
	g.setColor(Color.black);
	g.drawString(n.lbl, n.x + xgap, n.y + ygap + fm.getAscent());
    }

    public void update(Graphics g) {
	paint(g);
    }

    public void paint(Graphics g) {
	Dimension d = checksize();

	if (pick == null || oldpick != pick || (push && (oldover != over))) {
	    offGraphics.setColor(getBackground());
	    offGraphics.fillRect(0, 0, d.width, d.height);
	    for (int i = 0 ; i < nnodes ; i++) {
		if (nodes[i] != pick && nodes[i] != over) {
		    paintNode(offGraphics, nodes[i], fm);
		}
	    }
	    oldpick = pick;
	    oldover = over;
	}

	offGraphics2.drawImage(offscreen, 0, 0, null);

	if (pick != null) {
	    paintNode(offGraphics2, pick, fm);
	}
	if (push && over != null)
	    paintNode(offGraphics2, over, fm);

	g.drawImage(offscreen2, 0, 0, null);

    }

    int nodeHit(int x, int y) {
	for (int i = nnodes - 1; i >= 0; i--) {
	    if (nodes[i].hit(x, y)) {
		return i;
	    }
	}
	return -1;
    }

    Node overlapNode(Node n) {
	for (int i = 0; i < nnodes - 1; i++) {
	    Node m = nodes[i];
	    if (n.overlap(m)) {
		return m;
	    }
	}
	return null;
    }

    Node front(int i) {
	Node n = nodes[i];
	for (int j = i; j < nnodes - 1; j++) {
	    nodes[j] = nodes[j+1];
	}
	nodes[nnodes - 1] = n;
	return n;
    }

    public boolean mouseDown(Event evt, int x, int y) {
	int node = nodeHit(x, y);
	if (node != -1) {
	    pick = front(node);
	    initover = overlapNode(pick);
	    dx = pick.x - x;
	    dy = pick.y - y;
	}
//	repaint(pick.x, pick.y, pick.w, pick.h);
	repaint();
	return true;
    }

    public boolean mouseDrag(Event evt, int x, int y) {
	if (pick != null) {
	    int ox = pick.x;
	    int oy = pick.y;
	    int mx = x - ox;
	    int my = y - oy;
	    pick.move(x + dx, y + dy);
	    over = overlapNode(pick);
	    if (over == null) {
		initover = null;
	    } else if (initover != over && push) {
		over.adjust(pick, ox, oy);
	    }
	    repaint();
	}
	return true;
    }

    public boolean mouseUp(Event evt, int x, int y) {
	if (pick != null) {
	    pick.move(x + dx, y + dy);
	    pick = null;
	    over = null;
	    repaint();
	}
	return true;
    }

    public void start() {
    }
    public void stop() {
    }

    public Dimension checksize() {
	Dimension d = size();

	if (d.width < 1 || d.height < 1)
	    return d;
	if ((offscreen == null) ||
	    (d.width != offscreensize.width) ||
	    (d.height != offscreensize.height)) {
	    offscreen = createImage(d.width, d.height);
	    offscreensize = d;
	    offGraphics = offscreen.getGraphics();
	    offGraphics.setFont(getFont());
	    fm = offGraphics.getFontMetrics();
	    offscreen2 = createImage(d.width, d.height);
	    offGraphics2 = offscreen2.getGraphics();
	    offGraphics2.setFont(getFont());

	    for (int i = 0 ; i < nnodes ; i++) {
		Node n = nodes[i];
		n.w = fm.stringWidth(n.lbl) + 2 * xgap;
		n.h = fm.getHeight() + 2 * ygap;
	    }
	    scramble();
	}
	return d;
    }

    void scramble() {
	Dimension d = size();
	for (int i = 0 ; i < nnodes ; i++) {
	    Node n = nodes[i];
	    boolean clear;
	    int q = 0;
	    do {
		n.move(
		       (int)(xgap + (d.width-2*xgap-n.w)*Math.random()),
		       (int)(ygap + (d.height-2*ygap-n.h)*Math.random()));
		clear = true;
		if (!overlap && q < 30)
		    for (int j = 0 ; j < i ; j++)
			if (nodes[i].overlap(nodes[j]))
			    clear = false;
		q++;
	    } while(!clear);
	}
    }

    void nudge() {
	Dimension d = size();
	int nudgeDelta = 30;
	for (int i = 0 ; i < nnodes ; i++) {
	    Node n = nodes[i];
	    boolean clear;
	    int q = 0;
	    do {
		nodes[i].rmove(
		     (int)(nudgeDelta*Math.random() - nudgeDelta/2),
		     (int)(nudgeDelta*Math.random() - nudgeDelta/2));
		clear = true;
		if (!overlap && q < 30)
		    for (int j = 0 ; j < i ; j++)
			if (nodes[i].overlap(nodes[j]))
			    clear = false;
		q++;
	    } while(!clear);
	}
    }

    void pack() {
	Dimension d = size();
	int x = xgap;
	int y = d.height - nodes[0].h - ygap;
	for (int i = 0 ; i < nnodes ; i++) {
	    Node n = nodes[i];
	    n.move(x, y);
	    x += n.w + xgap;
	    if (i+1 < nnodes && nodes[i+1].w + x > d.width - xgap) {
		x = xgap;
		y -= nodes[i].h;
	    }
	}
    }

}

public class Poetry extends Applet implements Runnable {
    PoetryPanel panel;

    public void init() {
	setLayout(new BorderLayout());

	panel = new PoetryPanel();
	add("Center", panel);
	Panel p = new Panel();
	add("South", p);
	p.add(new Button("Scramble"));
	p.add(new Button("Nudge"));
	p.add(new Button("Pack"));
	p.add(new Checkbox("Push"));
	p.add(new Checkbox("No Overlap"));

	String words = getParameter("words");
	if (words == null)
	    words = "Get,me,some,words";
	StringTokenizer t = new StringTokenizer(words, ",");
	while (t.hasMoreTokens()) {
	    String str = t.nextToken();
	    panel.addNode(str);
	}
    }

    public boolean action(Event evt, Object arg) {
	if (arg instanceof Boolean) {
	    if ("Push".equals(((Checkbox)evt.target).getLabel())) {
		panel.push = ((Boolean)arg).booleanValue();
	    } else {
		panel.overlap = !(((Boolean)arg).booleanValue());
	    }
	    return true;
	} else if ("Scramble".equals(arg)) {
	    panel.scramble();
	    panel.repaint();
	    new Thread(this).start();
	    return true;
	} else if ("Nudge".equals(arg)) {
	    panel.nudge();
	    panel.repaint();
	    return true;
	} else if ("Pack".equals(arg)) {
	    panel.pack();
	    panel.repaint();
	    return true;
	}

	return false;
    }
    public void run() {
	for (int i = 0; i < 10; i++) {
	    panel.scramble();
	    panel.repaint();
	    try Thread.sleep(250); catch(Exception e);
	}
    }
}
